#ifndef SIMULATIONENGINEENCODERDECODER_H_
#define SIMULATIONENGINEENCODERDECODER_H_

#include "../Configuration/ConfigurationServer.h"
#include "../DataTypes/DataRequest.h"
#include "../DataTypes/DataFloat.h"
#include "../DataTypes/Vector3f.h"
#include "../DataTypes/DataDouble.h"
#include "../DataTypes/DataBool.h"
#include "../DataTypes/DataString.h"
#include "../DataTypes/DataRobot.h"
#include "../DataTypes/DataMaterial.h"
#include "../DataTypes/DataMaterialInteraction.h"
#include "../DataTypes/DataBall.h"
#include "../DataTypes/DataField.h"
#include "../DataTypes/DataInteger.h"
#include "../DataTypes/DataObject.h"
#include "../DataTypes/DataControlRequest.h"
#include "../DataTypes/DataEntityRequest.h"
#include "../DataTypes/DataWheelJoint.h"
#include "../DataTypes/DataWheelJointVelocity.h"
#include "../DataTypes/DataFixedJoint.h"
#include "../DataTypes/DataBox.h"
#include "../DataTypes/DataSphere.h"
#include "../DataTypes/DataWheelCylinder.h"
#include "../DataTypes/DataCylinder.h"
#include <string>
#include <iostream>
#include "../XmlParser/xmlParser.h"
using namespace DataTypes;
using namespace std;
using namespace Configuration;
namespace SimulationEngine
{

class SimulationEngineEncoderDecoder
{
public:
	static SimulationEngineEncoderDecoder* GetInstance();
	list<DataRequest *>DecodeMessage(string message);
	string EncodeMessage(list<DataParameter *>);
protected:
	SimulationEngineEncoderDecoder();
private:
	DataRequest *DecodeControl(XMLNode controlrequestnode);
	DataRequest *DecodeEntity(XMLNode entityrequestnode);
	DataRequest *DecodeBall(XMLNode ball);
	DataRequest *DecodeField(XMLNode field);
	DataRequest *DecodeRobot(XMLNode robot);
	static SimulationEngineEncoderDecoder *instance;
	ConfigurationServer *conf; 
};

}

#endif /*SIMULATIONENGINEENCODERDECODER_H_*/
